// Ustawienia kompilacji modulow
#define XE_COMPILE_ECHO				// Uzywamy komponent XeComponentAudio.h
#define XE_COMPILE_NOT_INTRO_SOUND // Brak dwiku przy logu Xenon'a

// Dolaczenie pliku naglowkowego frameworka
#include "System/XenonCoreFramework.h"

// Dolaczenie plikow naglowkowych komponentow
#include "Components/XeComponentApp.h"
#include "Components/XeComponentImage.h"
#include "Components/XeComponentGui.h"

// Uzywamy przestrzen nazw XeCore i podprzestrzeni modulow
using namespace XeCore;
using namespace XeCore::Photon;		// modul graficzny
using namespace XeCore::Chaos;		// modul fizyczny
using namespace XeCore::Psyche;		// modul sztucznej inteligencji
using namespace XeCore::TimeBridge;	// modul kontroli czasu wirtualnego
using namespace XeCore::Ether;		// modul sieciowy

// Uzywamy przestrzeni nazw komponentow
using namespace XeCore::Com;

// Dolaczenie plikow naglowkowych danych i zdarzen aplikacji
#include "Application/AppData.h"
#include "Application/Gui.h"
#include "Application/AppEvents.h"

// Funkcja glowna aplikacji
XE_MAIN_BEGIN	// rozpoczynamy procedure aplikacji

	// Ustawienia interface'u
	Game.Windows( "main" )->Name = "Blast Me";	// automatyczne utworzenie obiektu okna i nadanie mu nazwy
	Game.Windows( "main" )->ColorDepth = 32;		// ustawienie glebi kolorow
	Game.Windows( "main" )->Zdepth = 16;			// ustawienie bufora glebi
	XE_IO::Use().PressOnce = true;					// sprawia ze wcisniety klawisz nie odnawia swojego stanu przy dluzszym przytrzymaniu
	XE_MATH::RandomReset();							// resetujemy ustawienia losowania

	// Ustawienia scen
	Game.Scenes.Scenes.Access( "intro" ) = XeIntroScene;	// dodajemy zdarzenie sceny do listy scen gry (Logo Xenon'a)
	Game.Scenes.Scenes.Access( "menu" ) = MenuScene;		// Menu gry
	Game.Scenes.Scenes.Access( "game" ) = GameScene;		// Gra
	Game.Scenes.Scenes.Access( "tutorial" ) = TutorialScene;// Pomoc
	Game.Scenes.Scenes.Access( "editor" ) = EditorScene;	// Edytor
	Game.Scenes.Active = Game.Scenes.Scenes( "intro" );		// ustawiamy intro jako aktywna scene 

	// Utworzenie okna gry
	if( !Game.Windows( "main" )->Create() ) return(0);	// tworzymy okno i jesli nie zostanie utworzone to konczymy program

	// Odtworzenie scen (sa odtwarzane jedna po drugiej (gdy ustawimy wlasciwosc sceny Autonext na true) wedlug kolejnosci ich dodania, zaczynajac od aktywnej)
	Game.Scenes.Play();

	// Zniszczenie okna
	Game.Windows( "main" )->Destroy();

XE_MAIN_END		// konczymy procedure aplikacji
